/*==============================================================================
* Labor market series for Austria
*=============================================================================*/
clear all
set more off

cd "$insheet_files/Austria"

*===============================================================================
* Data from Censuses: 1971, 1981
*===============================================================================

foreach year in 1981 1971 {
	import excel "AT census 1971 1981.xlsx", first sheet("`year'") clear 
	
	gen year = `year'
	
	tempfile AT_cens_`year'
	save 	 `AT_cens_`year'.dta'
}

append using `AT_cens_1981.dta'

foreach var of varlist POP EMP UNEMP LF { //convert to thousands
	replace `var' = `var'/1000
}

rename POP	POP_cens_AT
rename EMP 	EMP_cens_AT 
rename UNEMP 	UNEMP_cens_AT
rename LF	LF_cens_AT

label var POP_cens_AT	"Population, AT Census"
label var EMP_cens_AT 	"Employed, AT Census"
label var UNEMP_cens_AT "Unemployed, AT Census"
label var LF_cens_AT 	"Labor Force, AT Census"

tempfile AT_cens
save `AT_cens.dta'

*===============================================================================
*		Data from annual Labor Force Surveys, 1974-2012
*===============================================================================
clear
import excel "Austrian Microcensus, Employment Status, 1974-2012, by sex.xls", ///
		first cellrange(A8:AP117) clear

rename Sex sex
split ProvinceNUTS2unit9, p("<")
gen nuts = substr(ProvinceNUTS2unit92, 1,4)
rename ProvinceNUTS2unit91 region_name
drop ProvinceNUTS2unit9*
drop if nuts=="0>" //unclasifiable

foreach var of varlist y* {
	quietly destring `var', replace force
}

reshape long y,i(nuts region_name sex ActivitystatusbyLUKuntil19) j(year)

drop if y==.
replace Activity = substr(Activity,1,7)

reshape wide y, i(nuts region_name sex year) j(ActivitystatusbyLUKuntil19) string
reshape wide yE yI yU yC yP, i(nuts region_name year ) j(sex) string

egen POP_LFS_AT = rsum(yCompulsfemale-yUnemplomale)
egen EMP_LFS_AT = rsum(yEmp*)
egen UNEMP_LFS_AT = rsum(yUnemp*)
egen LF_LFS_AT = rsum(EMP_LFS_AT UNEMP_LFS_AT)

label var EMP_LFS_AT 	"Employed, Labor force survey"
label var UNEMP_LFS_AT 	"Unemployed, Labor force survey"
label var LF_LFS_AT 	"Labor Force, Labor force survey"

keep nuts region_name year POP EMP UNEMP LF
 
*===============================================================================
* Merge data
*===============================================================================

merge 1:1 nuts year using `AT_cens.dta', nogen

save "$dta_files/AT_labor.dta", replace

